/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay;

import com.digiwin.dap.middleware.dwpay.ClientConfiguration;
import com.digiwin.dap.middleware.dwpay.DwPay;
import com.digiwin.dap.middleware.dwpay.common.comm.DefaultServiceClient;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;
import com.digiwin.dap.middleware.dwpay.internal.model.TradeParam;
import com.digiwin.dap.middleware.dwpay.internal.model.TradePeriod;
import com.digiwin.dap.middleware.dwpay.internal.operation.TradeOperation;
import com.digiwin.dap.middleware.dwpay.model.AlterType;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeRequest;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwPayClient
implements DwPay {
    private static final Logger logger = LoggerFactory.getLogger(DwPayClient.class);
    protected ServiceClient serviceClient;
    private TradeOperation tradeOperation;

    DwPayClient(DwPayConfig config) {
        this(config, null);
    }

    DwPayClient(DwPayConfig config, ClientConfiguration clientConfig) {
        DwPayConfig.check(config);
        this.serviceClient = clientConfig == null ? new DefaultServiceClient(config) : new DefaultServiceClient(config, clientConfig);
        this.initOperations();
    }

    public void initOperations() {
        this.tradeOperation = new TradeOperation(this.serviceClient);
    }

    @Override
    public String pay(Object data, String userToken) {
        TradeRequest body = new TradeRequest();
        body.setData(data);
        body.addHeader("digi-middleware-auth-user", userToken);
        return this.tradeOperation.pay(body);
    }

    @Override
    public TradeInfo query(String sourceId, String outTradeNo, String userToken) {
        TradeRequest body = new TradeRequest();
        body.setData(new TradeParam(sourceId, outTradeNo));
        body.addHeader("digi-middleware-auth-user", userToken);
        return this.tradeOperation.query(body);
    }

    @Override
    public TradeResult close(String sourceId, String outTradeNo, String userToken) {
        TradeRequest body = new TradeRequest();
        body.setData(new TradeParam(sourceId, outTradeNo));
        body.addHeader("digi-middleware-auth-user", userToken);
        return this.tradeOperation.close(body);
    }

    @Override
    public TradeResult alterStatus(String sourceId, String outTradeNo, AlterType alterType, String userToken) {
        TradeRequest body = new TradeRequest();
        TradePeriod tradePeriod = new TradePeriod();
        tradePeriod.setSourceId(sourceId);
        tradePeriod.setOutTradeNo(outTradeNo);
        tradePeriod.setAlterType(alterType);
        body.setData(tradePeriod);
        body.addHeader("digi-middleware-auth-user", userToken);
        return this.tradeOperation.alterStatus(body);
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            logger.error("shutdown throw exception: ", (Throwable)e);
        }
    }

    @Override
    public String getConnectionPoolStats() {
        try {
            return this.serviceClient.getConnectionPoolStats();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

