/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.comm;

import com.digiwin.dap.middleware.dwpay.ClientConfiguration;
import com.digiwin.dap.middleware.dwpay.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dwpay.common.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.dwpay.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dwpay.common.utils.HttpUtil;
import com.digiwin.dap.middleware.dwpay.common.utils.StreamUtils;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager = this.createHttpClientConnectionManager();
    protected RequestConfig requestConfig;
    protected DwPayConfig config;

    public DefaultServiceClient(DwPayConfig config) {
        this(config, new ClientConfiguration());
    }

    public DefaultServiceClient(DwPayConfig config, ClientConfiguration clientConfig) {
        super(clientConfig);
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(clientConfig.getConnectionTimeout());
        builder.setSocketTimeout(clientConfig.getSocketTimeout());
        builder.setConnectionRequestTimeout(clientConfig.getConnectionRequestTimeout());
        this.requestConfig = builder.build();
        this.config = config;
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            response.setContent(httpResponse.getEntity().getContent());
            if (!response.isSuccessful()) {
                String content = StreamUtils.copyToString(response.getContent(), StandardCharsets.UTF_8);
                response.setError(content);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request, ExecutionContext context) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        this.handleCommonToken(httpRequest);
        HttpClientContext httpContext = this.createHttpContext(request);
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    @Override
    public DwPayConfig getConfig() {
        return this.config;
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    @Override
    public String getConnectionPoolStats() {
        if (this.connectionManager != null && this.connectionManager instanceof PoolingHttpClientConnectionManager) {
            PoolingHttpClientConnectionManager conn = (PoolingHttpClientConnectionManager)this.connectionManager;
            return conn.getTotalStats().toString();
        }
        return "";
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnections());
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.clientConfig.getSocketTimeout()).build());
        if (this.clientConfig.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.clientConfig.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().setRetryHandler(this.clientConfig.getRetryHandler()).addInterceptorLast(this.clientConfig.getResponseInterceptor()).build();
    }

    private void handleCommonToken(HttpRequestBase httpRequest) {
        this.putHeaderIfAbsent(httpRequest, "digi-middleware-auth-app", this.config.getAppToken());
    }

    private void putHeaderIfAbsent(HttpRequestBase httpRequest, String name, String value) {
        if (!httpRequest.containsHeader(name)) {
            httpRequest.setHeader(name, value);
        }
    }

    private HttpClientContext createHttpContext(RequestMessage request) {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        httpContext.setAttribute("dwPay-sdkretry", (Object)request.isForceRetry());
        return httpContext;
    }
}

