/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal;

import com.digiwin.dap.middleware.dwpay.ClientException;
import com.digiwin.dap.middleware.dwpay.DwPayException;
import com.digiwin.dap.middleware.dwpay.ServiceException;
import com.digiwin.dap.middleware.dwpay.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dwpay.common.parser.ResponseParser;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import com.digiwin.dap.middleware.dwpay.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;
import com.digiwin.dap.middleware.dwpay.internal.ErrorResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DwPayOperation {
    protected static final Logger logger = LoggerFactory.getLogger(DwPayOperation.class);
    protected static ResponseHandler errorResponseHandler = new ErrorResponseHandler();
    protected ServiceClient client;
    protected DwPayConfig config;

    protected DwPayOperation(ServiceClient client) {
        this.client = client;
        this.config = client.getConfig();
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser) {
        return this.doOperation(request, parser, true);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, boolean keepResponseOpen) {
        ExecutionContext context = this.createDefaultContext();
        ResponseMessage response = this.send(request, context, keepResponseOpen);
        try {
            response.setAppSecret(this.config.getAppSecret());
            return parser.parse(response);
        }
        catch (ResponseParseException rpe) {
            DwPayException de = ExceptionFactory.createInvalidResponseException(response.getRequestId(), rpe.getMessage(), rpe);
            logger.error("Unable to parse response error: ", (Throwable)rpe);
            throw de;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws ServiceException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                DwPayUtils.safeCloseResponse(response);
            }
        }
    }

    protected ExecutionContext createDefaultContext() {
        ExecutionContext context = new ExecutionContext();
        context.addResponseHandler(errorResponseHandler);
        return context;
    }
}

