/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal;

import com.digiwin.dap.middleware.dwpay.ClientException;
import com.digiwin.dap.middleware.dwpay.DwPayException;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.parser.ErrorResponseParser;
import com.digiwin.dap.middleware.dwpay.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import com.digiwin.dap.middleware.dwpay.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dwpay.internal.model.StdError;

public class ErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws DwPayException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createDMCException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createDMCException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createDMCException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            if (statusCode == 403) {
                throw ExceptionFactory.createDMCException(requestId, "AccessForbidden", "AccessForbidden");
            }
            throw ExceptionFactory.createUnknownDMCException(requestId, statusCode);
        }
        try {
            try {
                ErrorResponseParser parser = new ErrorResponseParser();
                StdError stdError = parser.parse(response);
                throw ExceptionFactory.createDMCException(stdError);
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, response.getError(), e);
            }
        }
        catch (Throwable throwable) {
            DwPayUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

