package com.digiwin.dap.middleware.dwpay;

import com.digiwin.dap.middleware.dwpay.model.AlterType;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;


/**
 * 支付中心，集成各种第三代支付方式，提供统一的对外入口
 * <p>
 * 大陆：
 * <ol>
 * <li>支付宝</li>
 * <li>微信</li>
 * <li>银联</li>
 * </ol>
 * <p>
 * 台湾：
 * <ol>
 * <li>蓝新金流</li>
 * </ol>
 *
 * @author fobgochod
 * @since 1.0.0
 */
public interface DwPay {

    /**
     * 获取交易地址
     *
     * @param data      交易信息
     * @param userToken userToken
     * @return 支付链接
     */
    TradeResult pay(Object data, String userToken);

    /**
     * 查询交易
     *
     * @param sourceId   来源ID
     * @param outTradeNo 商户订单号
     * @param userToken  userToken
     * @return 交易信息
     */
    TradeInfo query(String sourceId, String outTradeNo, String userToken);

    /**
     * 关闭交易
     *
     * @param sourceId   来源ID
     * @param outTradeNo 商户订单号
     * @param userToken  userToken
     * @return 交易关系结果信息
     */
    TradeResult close(String sourceId, String outTradeNo, String userToken);

    /**
     * 更新委托支付状态
     *
     * @param sourceId   来源ID
     * @param outTradeNo 商户订单号
     * @param alterType  委托状态
     * @param userToken  userToken
     * @return 状态更新结果
     */
    TradeResult alterStatus(String sourceId, String outTradeNo, AlterType alterType, String userToken);

    /**
     * Shuts down the EMC instance (release all resources) The EMC instance is
     * not usable after its shutdown() is called.
     */
    void shutdown();

    /**
     * 连接池统计信息
     *
     * @return 统计信息
     */
    String getConnectionPoolStats();
}
