package com.digiwin.dap.middleware.dwpay;

import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;

/**
 * Fluent builder for DwPay Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public interface DwPayBuilder {

    /**
     * create a new {@link DwPayClient} instance.
     *
     * @return {@link DwPayClient} instance
     */
    static DwPayBuilder create() {
        return new DwPayClientBuilder();
    }


    /**
     * Uses the parameters to create a new {@link DwPayClient} instance.
     *
     * @param uri       server uri
     * @param appToken  app token
     * @param appSecret app secret
     * @return {@link DwPayClient} instance
     */
    DwPay build(String uri, String appToken, String appSecret);

    /**
     * Uses the DwPayConfig to create a new {@link DwPayClient} instance.
     *
     * @param config 基础配置信息
     * @return {@link DwPayClient} instance
     */
    DwPay build(DwPayConfig config);

    /**
     * Uses the DwPayConfig to create a new {@link DwPayClient} instance.
     *
     * @param config       基础配置信息
     * @param clientConfig Client configurations for accessing to DMC services
     * @return {@link DwPayClient} instance
     */
    DwPay build(DwPayConfig config, ClientConfiguration clientConfig);
}
