package com.digiwin.dap.middleware.dwpay;

import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;

/**
 * Fluent builder for DwPay Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public final class DwPayClientBuilder implements DwPayBuilder {

    public DwPayClientBuilder() {
    }

    @Override
    public DwPay build(String uri, String appToken, String appSecret) {
        DwPayConfig config = new DwPayConfig();
        config.setUri(uri);
        config.setAppToken(appToken);
        config.setAppSecret(appSecret);
        return build(config);
    }

    @Override
    public DwPay build(DwPayConfig config) {
        return new DwPayClient(config);
    }

    @Override
    public DwPay build(DwPayConfig config, ClientConfiguration clientConfig) {
        return new DwPayClient(config, clientConfig);
    }
}
