package com.digiwin.dap.middleware.dwpay;

/**
 * The DMCException is thrown upon error when accessing DMC.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class DwPayException extends ServiceException {

    private static final long serialVersionUID = -1979779664334663173L;

    private String resourceType;
    private String header;
    private String method;

    public DwPayException() {
        super();
    }

    public DwPayException(String errorMessage) {
        super(errorMessage);
    }

    public DwPayException(Throwable cause) {
        super(cause);
    }

    public DwPayException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public DwPayException(String errorMessage, String errorCode) {
        super(errorMessage, errorCode, null, null);
    }

    public DwPayException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                          String resourceType, String method) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, null, null);
    }

    public DwPayException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                          String resourceType, String method, Throwable cause) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, null, cause);
    }

    public DwPayException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                          String resourceType, String method, String rawResponseError) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, rawResponseError, null);
    }

    public DwPayException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                          String resourceType, String method, String rawResponseError, Throwable cause) {
        super(errorMessage, errorCode, requestId, hostId, rawResponseError, cause);
        this.resourceType = resourceType;
        this.header = header;
        this.method = method;
    }

    public String getResourceType() {
        return resourceType;
    }

    public String getHeader() {
        return header;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (resourceType == null ? "" : "\n[ResourceType]: " + resourceType)
                + (header == null ? "" : "\n[Header]: " + header) + (method == null ? "" : "\n[Method]: " + method);
    }
}
