package com.digiwin.dap.middleware.dwpay.common.comm;

import java.util.LinkedList;
import java.util.List;

/**
 * HTTP request context.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class ExecutionContext {

    /**
     * The request handlers that handle request content in as a pipeline.
     */
    private List<RequestHandler> requestHandlers = new LinkedList<>();

    /**
     * The response handlers that handle response message in as a pipeline.
     */
    private List<ResponseHandler> responseHandlers = new LinkedList<>();


    public List<ResponseHandler> getResponseHandlers() {
        return responseHandlers;
    }

    public void addResponseHandler(ResponseHandler handler) {
        responseHandlers.add(handler);
    }

    public void insertResponseHandler(int position, ResponseHandler handler) {
        responseHandlers.add(position, handler);
    }

    public void removeResponseHandler(ResponseHandler handler) {
        responseHandlers.remove(handler);
    }

    public List<RequestHandler> getRequestHandlers() {
        return requestHandlers;
    }

    public void addRequestHandler(RequestHandler handler) {
        requestHandlers.add(handler);
    }

    public void insertRequestHandler(int position, RequestHandler handler) {
        requestHandlers.add(position, handler);
    }

    public void removeRequestHandler(RequestHandler handler) {
        requestHandlers.remove(handler);
    }
}
