package com.digiwin.dap.middleware.dwpay.common.comm;

import com.digiwin.dap.middleware.dwpay.HttpMethod;
import com.digiwin.dap.middleware.dwpay.internal.model.GenericRequest;
import org.apache.hc.core5.http.HttpEntity;

import java.net.URI;

/**
 * Represent HTTP requests sent to DMC.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class RequestMessage extends HttpMessage {

    /**
     * The original request provided by user
     */
    private final GenericRequest originalRequest;
    /**
     * The service endpoint to which this request should be sent
     */
    private URI endpoint;
    /**
     * The HTTP method to use when sending this request
     */
    private HttpMethod method = HttpMethod.GET;
    /**
     * the entity associated with this request
     */
    private HttpEntity httpEntity;
    /**
     * 是否白名单，白名单不需要传token
     */
    private boolean whitelist;
    /**
     * 非幂等API，在特殊状态码如502、503时，强制重试
     */
    private boolean forceRetry;

    private String appSecret;


    public RequestMessage() {
        this(null);
    }

    public RequestMessage(GenericRequest originalRequest) {
        this.originalRequest = (originalRequest == null) ? GenericRequest.NOOP : originalRequest;
    }

    public URI getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpEntity getHttpEntity() {
        return httpEntity;
    }

    public void setHttpEntity(HttpEntity httpEntity) {
        this.httpEntity = httpEntity;
    }

    public boolean isWhitelist() {
        return whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public boolean isForceRetry() {
        return forceRetry;
    }

    public void setForceRetry(boolean forceRetry) {
        this.forceRetry = forceRetry;
    }

    public GenericRequest getOriginalRequest() {
        return originalRequest;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }
}
