package com.digiwin.dap.middleware.dwpay.common.comm;

import com.digiwin.dap.middleware.dwpay.internal.DwPayConstants;

/**
 * response message
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class ResponseMessage extends HttpMessage {

    private static final int HTTP_SUCCESS_STATUS_CODE = 200;

    private String uri;
    private int statusCode;

    /**
     * For convenience of logging invalid response
     */
    private String error;

    private String appSecret;


    public String getUri() {
        return uri;
    }

    public void setUrl(String uri) {
        this.uri = uri;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getRequestId() {
        return getHeaders().get(DwPayConstants.HTTP_HEADER_REQUEST_ID);
    }

    public boolean isSuccessful() {
        return statusCode / 100 == HTTP_SUCCESS_STATUS_CODE / 100;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }
}
