package com.digiwin.dap.middleware.dwpay.common.parser;

import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.internal.model.StdError;
import com.digiwin.dap.middleware.util.JsonUtils;

/**
 * Used to convert an result stream to a java object.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class ErrorResponseParser implements ResponseParser<StdError> {

    @Override
    public StdError parse(ResponseMessage response) throws ResponseParseException {
        return JsonUtils.jsonToObj(response.getError(), StdError.class);
    }
}
