package com.digiwin.dap.middleware.dwpay.internal;


/**
 * Defines a builder that adds a config to the DMCConfig entity.
 *
 * @author fobgochod
 * @since 5.2.0.0
 */
public final class DwPayConfigBuilder {

    private String uri;
    private String appToken;
    private String appSecret;

    /**
     * Enforce the use of factory methods.
     */
    private DwPayConfigBuilder() {
    }

    public static DwPayConfigBuilder create() {
        return new DwPayConfigBuilder();
    }

    public static DwPayConfigBuilder create(String uri) {
        return new DwPayConfigBuilder().uri(uri);
    }

    public DwPayConfigBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public DwPayConfigBuilder appToken(String appToken) {
        this.appToken = appToken;
        return this;
    }

    public DwPayConfigBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public DwPayConfig build() {
        DwPayConfig config = new DwPayConfig();
        config.setUri(uri);
        config.setAppToken(appToken);
        config.setAppSecret(appSecret);
        return config;
    }
}
