package com.digiwin.dap.middleware.dwpay.internal.model;

public enum PayType {

    /**
     * @see <a href="https://open.alipay.com/api">快速集成支付宝API</a>
     */
    Alipay,
    /**
     * @see <a href="https://open.alipay.com/api">快速集成支付宝移动端API</a>
     */
    AliWapPay,

    /**
     * @see <a href="https://www.newebpay.com/website/Page/content/download_api">信用卡定期定额支付</a>
     */
    MPGPeriod,

    /**
     * @see <a href="https://www.newebpay.com/website/Page/content/download_api">蓝新金流-线上交易</a>
     */
    MPG,

    /**
     * @see <a href="https://pay.weixin.qq.com/wiki/doc/api/native.php?chapter=6_5">微信支付-扫码支付</a>
     */
    Wxpay;
}