package com.digiwin.dap.middleware.dwpay.internal.operation;

import com.digiwin.dap.middleware.dwpay.HttpMethod;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.internal.DwPayOperation;
import com.digiwin.dap.middleware.dwpay.internal.DwPayRequestMessageBuilder;
import com.digiwin.dap.middleware.dwpay.internal.ResponseParsers;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeRequest;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;

public class TradeOperation extends DwPayOperation {

    public TradeOperation(ServiceClient client) {
        super(client);
    }

    public TradeResult pay(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create()
                .setEndpoint(config.getPayUri())
                .setMethod(HttpMethod.POST)
                .setHeaders(trade.getHeaders())
                .setEntity(trade.getEntity(config.getAppSecret()))
                .setForceRetry(true)
                .setOriginalRequest(trade)
                .setAppSecret(config.getAppSecret())
                .build();
        return doOperation(request, ResponseParsers.tradePayResponseParser);
    }

    public TradeInfo query(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create()
                .setEndpoint(config.getQueryUri())
                .setMethod(HttpMethod.POST)
                .setHeaders(trade.getHeaders())
                .setAppSecret(config.getAppSecret())
                .setEntity(trade.getEntity(config.getAppSecret()))
                .setForceRetry(true)
                .setOriginalRequest(trade)
                .build();
        return doOperation(request, ResponseParsers.tradeQueryResponseParses);
    }


    public TradeResult close(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create()
                .setEndpoint(config.getCloseUri())
                .setMethod(HttpMethod.POST)
                .setHeaders(trade.getHeaders())
                .setEntity(trade.getEntity(config.getAppSecret()))
                .setForceRetry(true)
                .setOriginalRequest(trade)
                .setAppSecret(config.getAppSecret())
                .build();
        return doOperation(request, ResponseParsers.tradeCloseResponseParser);
    }

    public TradeResult alterStatus(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create()
                .setEndpoint(config.getMpgAlterStatusUri())
                .setMethod(HttpMethod.POST)
                .setHeaders(trade.getHeaders())
                .setEntity(trade.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(trade)
                .setAppSecret(config.getAppSecret())
                .build();
        return doOperation(request, ResponseParsers.tradeMqgResponseParser);
    }
}
