package com.digiwin.dap.middleware.dwpay.model;

import cn.hutool.core.net.URLEncodeUtil;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConstants;
import com.digiwin.dap.middleware.dwpay.internal.model.DapEncrypt;
import com.digiwin.dap.middleware.dwpay.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

import java.util.HashMap;

public class TradeRequest extends GenericRequest {

    private Object data;

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }


    @Override
    public HttpEntity build() {
        return EntityBuilder.create().setText(JsonUtils.writeValue(this.data))
                .setContentType(ContentType.APPLICATION_JSON)
                .build();
    }

    @Override
    public HttpEntity build(String appSecret) {
        // 加密
        String eData = AES.encryptIvCBC(JsonUtils.objToJson(data), appSecret);
        DapEncrypt body = new DapEncrypt(eData);
        // 加签
        HashMap<String, String> signData = new HashMap<>();
        SignUtils.sign(signData, appSecret, JsonUtils.objToMap(body));
        addHeader(DwPayConstants.HTTP_HEADER_SIGN_ARG_KEY, URLEncodeUtil.encode(JsonUtils.objToJson(signData)));
        return EntityBuilder.create().setText(JsonUtils.writeValue(body))
                .setContentType(ContentType.APPLICATION_JSON)
                .build();
    }
}
