package com.digiwin.dap.middleware.dwpay.model;

/**
 * 交易状态
 * <p>
 * 支付宝交易状态
 * WAIT_BUYER_PAY（交易创建，等待买家付款）、
 * TRADE_SUCCESS（交易支付成功）、
 * TRADE_CLOSED（未付款交易超时关闭，或支付完成后全额退款）、
 * TRADE_FINISHED（交易结束，不可退款）
 * <p>
 * 蓝新金流交易状态
 * 0=未付款
 * 1=付款成功
 * 2=付款失敗
 * 3=取消付款
 * 6=退款
 *
 * @author fobgochod
 */
public enum TradeStatus {

    WAIT_BUYER_PAY,

    TRADE_SUCCESS,

    TRADE_CLOSED,

    TRADE_FINISHED;

    public static TradeStatus mpg(int status) {
        if (status == 0) {
            return TradeStatus.WAIT_BUYER_PAY;
        } else if (status == 1) {
            return TradeStatus.TRADE_SUCCESS;
        } else {
            return TradeStatus.TRADE_CLOSED;
        }
    }

    public static TradeStatus getByVal(Integer val) {
        if (val == null) {
            return null;
        }
        for (TradeStatus objEnum : TradeStatus.values()) {
            if (objEnum.ordinal() == val) {
                return objEnum;
            }
        }
        return null;
    }

    public static boolean isEndState(Integer val) {
        if (val == null) {
            return false;
        }
        return TRADE_CLOSED.ordinal() == val || TRADE_FINISHED.ordinal() == val;
    }
}
