/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.comm;

import com.digiwin.dap.middleware.dwpay.ClientConfiguration;
import com.digiwin.dap.middleware.dwpay.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dwpay.common.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.dwpay.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dwpay.common.utils.HttpUtil;
import com.digiwin.dap.middleware.dwpay.common.utils.StreamUtils;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager = this.createHttpClientConnectionManager();
    protected RequestConfig requestConfig;
    protected DwPayConfig config;

    public DefaultServiceClient(DwPayConfig config) {
        this(config, new ClientConfiguration());
    }

    public DefaultServiceClient(DwPayConfig config, ClientConfiguration clientConfig) {
        super(clientConfig);
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)clientConfig.getConnectionTimeout()));
        builder.setResponseTimeout(Timeout.ofMilliseconds((long)clientConfig.getSocketTimeout()));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)clientConfig.getConnectionRequestTimeout()));
        this.requestConfig = builder.build();
        this.config = config;
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getCode() != 0) {
            response.setStatusCode(httpResponse.getCode());
        }
        if (httpResponse.getEntity() != null) {
            response.setContent(httpResponse.getEntity().getContent());
            if (!response.isSuccessful()) {
                String content = StreamUtils.copyToString(response.getContent(), StandardCharsets.UTF_8);
                response.setError(content);
            }
        }
        for (Header header : httpResponse.getHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request, ExecutionContext context) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpUriRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        this.handleCommonToken(httpRequest);
        HttpClientContext httpContext = this.createHttpContext(request);
        try {
            httpResponse = this.httpClient.execute((ClassicHttpRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    @Override
    public DwPayConfig getConfig() {
        return this.config;
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.remove(this.connectionManager);
        this.connectionManager.close(CloseMode.GRACEFUL);
    }

    @Override
    public String getConnectionPoolStats() {
        if (this.connectionManager != null && this.connectionManager instanceof PoolingHttpClientConnectionManager) {
            PoolingHttpClientConnectionManager conn = (PoolingHttpClientConnectionManager)this.connectionManager;
            return conn.getTotalStats().toString();
        }
        return "";
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnections());
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)this.clientConfig.getSocketTimeout())).build());
        if (this.clientConfig.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.clientConfig.getIdleConnectionTime());
            IdleConnectionReaper.register((HttpClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().setRetryStrategy(this.clientConfig.getRetryHandler()).addResponseInterceptorLast(this.clientConfig.getResponseInterceptor()).build();
    }

    private void handleCommonToken(HttpUriRequestBase httpRequest) {
        this.putHeaderIfAbsent(httpRequest, "digi-middleware-auth-app", this.config.getAppToken());
    }

    private void putHeaderIfAbsent(HttpUriRequestBase httpRequest, String name, String value) {
        if (!httpRequest.containsHeader(name)) {
            httpRequest.setHeader(name, (Object)value);
        }
    }

    private HttpClientContext createHttpContext(RequestMessage request) {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        httpContext.setAttribute("dwPay-sdkretry", (Object)request.isForceRetry());
        return httpContext;
    }
}

