/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.comm;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleConnectionReaper
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IdleConnectionReaper.class);
    private static final int REAP_INTERVAL_MILLISECONDS = 5000;
    private static final List<HttpClientConnectionManager> connectionManagers = new ArrayList<HttpClientConnectionManager>();
    private static IdleConnectionReaper instance;
    private static long idleConnectionTime;
    private volatile boolean shuttingDown;

    private IdleConnectionReaper() {
        super("idle_connection_reaper");
        this.setDaemon(true);
    }

    public static synchronized void register(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        connectionManagers.add(connectionManager);
    }

    public static synchronized void remove(HttpClientConnectionManager connectionManager) {
        connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            instance = null;
        }
        connectionManagers.clear();
    }

    public static synchronized int size() {
        return connectionManagers.size();
    }

    public static synchronized void setIdleConnectionTime(long idletime) {
        idleConnectionTime = idletime;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block8: while (true) {
            if (this.shuttingDown) {
                logger.debug("Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.digiwin.dap.middleware.dwpay.common.comm.IdleConnectionReaper.class
                ArrayList<HttpClientConnectionManager> connectionManagers = new ArrayList<HttpClientConnectionManager>(IdleConnectionReaper.connectionManagers);
                // MONITOREXIT : object
                object = connectionManagers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block8;
                    HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                    try {
                        if (!(connectionManager instanceof ConnPoolControl)) continue;
                        ConnPoolControl pool = (ConnPoolControl)connectionManager;
                        pool.closeExpired();
                        pool.closeIdle(TimeValue.ofMilliseconds((long)idleConnectionTime));
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to close idle connections", (Throwable)ex);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Reaper thread: ", t);
                continue;
            }
            break;
        }
    }

    static {
        idleConnectionTime = 60000L;
    }
}

