/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.utils;

import com.digiwin.dap.middleware.dwpay.ClientException;
import com.digiwin.dap.middleware.dwpay.DwPayException;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import com.digiwin.dap.middleware.dwpay.internal.model.StdError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.NonReadableChannelException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.NoHttpResponseException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonReadableChannelException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static DwPayException createInvalidResponseException(String requestId, String rawResponseError, Throwable cause) {
        return ExceptionFactory.createInvalidResponseException(requestId, DwPayUtils.DW_PAY_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()), rawResponseError);
    }

    public static DwPayException createInvalidResponseException(String requestId, String message, String rawResponseError) {
        return ExceptionFactory.createDMCException(requestId, "InvalidResponse", message, rawResponseError);
    }

    public static DwPayException createDMCException(String requestId, String errorCode, String message, String rawResponseError) {
        return new DwPayException(message, errorCode, requestId, null, null, null, null, rawResponseError);
    }

    public static DwPayException createDMCException(String requestId, String errorCode, String message) {
        return new DwPayException(message, errorCode, requestId, null, null, null, null);
    }

    public static DwPayException createUnknownDMCException(String requestId, int statusCode) {
        String message = "No body in response, http status code " + statusCode;
        return new DwPayException(message, "Unknown", requestId, null, null, null, null);
    }

    public static DwPayException createDMCException(StdError errorResult) {
        return new DwPayException(String.format("%s\uff1a%s", errorResult.getErrorMessage(), errorResult.getMessage()), errorResult.getErrorCode());
    }
}

