/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal.operation;

import com.digiwin.dap.middleware.dwpay.HttpMethod;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dwpay.internal.DwPayOperation;
import com.digiwin.dap.middleware.dwpay.internal.DwPayRequestMessageBuilder;
import com.digiwin.dap.middleware.dwpay.internal.ResponseParsers;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeRequest;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;

public class TradeOperation
extends DwPayOperation {
    public TradeOperation(ServiceClient client) {
        super(client);
    }

    public TradeResult pay(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create().setEndpoint(this.config.getPayUri()).setMethod(HttpMethod.POST).setHeaders(trade.getHeaders()).setEntity(trade.getEntity(this.config.getAppSecret())).setForceRetry(true).setOriginalRequest(trade).setAppSecret(this.config.getAppSecret()).build();
        return this.doOperation(request, ResponseParsers.tradePayResponseParser);
    }

    public TradeInfo query(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create().setEndpoint(this.config.getQueryUri()).setMethod(HttpMethod.POST).setHeaders(trade.getHeaders()).setAppSecret(this.config.getAppSecret()).setEntity(trade.getEntity(this.config.getAppSecret())).setForceRetry(true).setOriginalRequest(trade).build();
        return this.doOperation(request, ResponseParsers.tradeQueryResponseParses);
    }

    public TradeResult close(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create().setEndpoint(this.config.getCloseUri()).setMethod(HttpMethod.POST).setHeaders(trade.getHeaders()).setEntity(trade.getEntity(this.config.getAppSecret())).setForceRetry(true).setOriginalRequest(trade).setAppSecret(this.config.getAppSecret()).build();
        return this.doOperation(request, ResponseParsers.tradeCloseResponseParser);
    }

    public TradeResult alterStatus(TradeRequest trade) {
        RequestMessage request = DwPayRequestMessageBuilder.create().setEndpoint(this.config.getMpgAlterStatusUri()).setMethod(HttpMethod.POST).setHeaders(trade.getHeaders()).setEntity(trade.getEntity()).setForceRetry(true).setOriginalRequest(trade).setAppSecret(this.config.getAppSecret()).build();
        return this.doOperation(request, ResponseParsers.tradeMqgResponseParser);
    }
}

