package com.digiwin.dap.middleware.emc;

import com.digiwin.dap.middleware.emc.common.comm.CustomHttpRequestRetryHandler;
import com.digiwin.dap.middleware.emc.common.comm.CustomHttpResponseInterceptor;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.core5.http.HttpResponseInterceptor;

import java.util.LinkedList;

/**
 * Client configurations for accessing to EMC services.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class ClientConfiguration {

    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 180 * 1000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 50 * 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 50 * 1000;
    public static final int DEFAULT_MAX_CONNECTIONS = 1024;
    public static final long DEFAULT_CONNECTION_TTL = -1;
    public static final long DEFAULT_IDLE_CONNECTION_TIME = 60 * 1000;

    public static final boolean DEFAULT_USE_REAPER = true;

    protected int connectionRequestTimeout = DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    protected int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    protected int socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    protected int maxConnections = DEFAULT_MAX_CONNECTIONS;
    protected long connectionTTL = DEFAULT_CONNECTION_TTL;
    protected boolean useReaper = DEFAULT_USE_REAPER;
    protected long idleConnectionTime = DEFAULT_IDLE_CONNECTION_TIME;

    private HttpRequestRetryStrategy retryHandler = CustomHttpRequestRetryHandler.INSTANCE;
    private HttpResponseInterceptor responseInterceptor = CustomHttpResponseInterceptor.INSTANCE;

    public int getConnectionRequestTimeout() {
        return connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public long getConnectionTTL() {
        return connectionTTL;
    }

    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    public boolean isUseReaper() {
        return useReaper;
    }

    public void setUseReaper(boolean useReaper) {
        this.useReaper = useReaper;
    }

    public long getIdleConnectionTime() {
        return idleConnectionTime;
    }

    public void setIdleConnectionTime(long idleConnectionTime) {
        this.idleConnectionTime = idleConnectionTime;
    }

    public HttpRequestRetryStrategy getRetryHandler() {
        return retryHandler;
    }

    public void setRetryHandler(HttpRequestRetryStrategy retryHandler) {
        this.retryHandler = retryHandler;
    }

    public HttpResponseInterceptor getResponseInterceptor() {
        return responseInterceptor;
    }

    public void setResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
    }
}
