package com.digiwin.dap.middleware.emc;

import com.digiwin.dap.middleware.emc.model.MessageInfo;

/**
 * Entry point interface of DAP Middleware EMC (Message Management Center)
 * <p>
 * EMC消息中心SDk，方便开发人员快速方便的接发送任意形式的消息
 * </p>
 *
 * @author fobgochod
 * @since 1.0.0
 */
public interface EMC {

    /**
     * 发送消息，联系人使用配置
     *
     * @param eventId   事件ID
     * @param payload   消息内容
     * @param userToken userToken
     */
    void send(String eventId, Object payload, String userToken);

    /**
     * 发送消息，指定联系人
     *
     * @param eventId   事件ID
     * @param payload   消息内容
     * @param contacts  联系人
     * @param userToken userToken
     */
    void send(String eventId, Object payload, String contacts, String userToken);

    /**
     * 发送全部消息，需要指定消息类型
     *
     * @param message   目标目录ID
     * @param userToken 用户token
     */
    void send(MessageInfo message, String userToken);

    /**
     * Shuts down the EMC instance (release all resources) The EMC instance is
     * not usable after its shutdown() is called.
     */
    void shutdown();

    /**
     * 连接池统计信息
     *
     * @return 统计信息
     */
    String getConnectionPoolStats();
}
