package com.digiwin.dap.middleware.emc;

import com.digiwin.dap.middleware.emc.internal.EMCConfig;

/**
 * Fluent builder for EMC Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public interface EMCBuilder {

    /**
     * create a new {@link EMCClient} instance.
     *
     * @return {@link EMCClient} instance
     */
    static EMCBuilder create() {
        return new EMCClientBuilder();
    }

    /**
     * Uses the parameters to create a new {@link EMCClient} instance.
     *
     * @param uri      EMC server uri
     * @param appToken 应用appToken
     * @return {@link EMCClient} instance
     */
    EMC build(String uri, String appToken);


    /**
     * Uses the EMCConfig to create a new {@link EMCClient} instance.
     *
     * @param config 基础配置信息
     * @return {@link EMCClient} instance
     */
    EMC build(EMCConfig config);

    /**
     * Uses the EMCConfig to create a new {@link EMCClient} instance.
     *
     * @param config       基础配置信息
     * @param clientConfig Client configurations for accessing to EMC services
     * @return {@link EMCClient} instance
     */
    EMC build(EMCConfig config, ClientConfiguration clientConfig);
}
