package com.digiwin.dap.middleware.emc;

import com.digiwin.dap.middleware.emc.internal.EMCConfig;
import com.digiwin.dap.middleware.emc.internal.EMCConfigBuilder;

/**
 * Fluent builder for EMC Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public final class EMCClientBuilder implements EMCBuilder {

    @Override
    public EMC build(String uri, String appToken) {
        EMCConfig config = EMCConfigBuilder.create(uri, appToken).build();
        return new EMCClient(config);
    }

    @Override
    public EMC build(EMCConfig config) {
        return new EMCClient(config);
    }

    @Override
    public EMC build(EMCConfig config, ClientConfiguration clientConfig) {
        return new EMCClient(config, clientConfig);
    }
}
