package com.digiwin.dap.middleware.emc;

/**
 * EMC Server side error code.
 */
public interface EMCErrorCode {

    /**
     * Access Denied (401)
     */
    static final String ACCESS_DENIED = "AccessDenied";

    /**
     * Access Forbidden (403)
     */
    static final String ACCESS_FORBIDDEN = "AccessForbidden";

    /**
     * Invalid argument.
     */
    static final String INVALID_ARGUMENT = "InvalidArgument";

    /**
     * Non-existing Access ID
     */
    static final String INVALID_ACCESS_KEY_ID = "InvalidAccessKeyId";

    /**
     * EMC Internal error.
     */
    static final String INTERNAL_ERROR = "InternalError";

    /**
     * Missing content length.
     */
    static final String MISSING_CONTENT_LENGTH = "MissingContentLength";

    /**
     * Missing required argument.
     */
    static final String MISSING_ARGUMENT = "MissingArgument";

    /**
     * File does not exist.
     */
    static final String NO_SUCH_KEY = "NoSuchKey";

    /**
     * Version does not exist.
     */
    static final String NO_SUCH_VERSION = "NoSuchVersion";

    /**
     * Not implemented method.
     */
    static final String NOT_IMPLEMENTED = "NotImplemented";

    /**
     * Error occurred in precondition.
     */
    static final String PRECONDITION_FAILED = "PreconditionFailed";

    /**
     * 304 Not Modified。
     */
    static final String NOT_MODIFIED = "NotModified";

    /**
     * The time skew between the time in request headers and server is more than
     * 15 min.
     */
    static final String REQUEST_TIME_TOO_SKEWED = "RequestTimeTooSkewed";

    /**
     * Request times out.
     */
    static final String REQUEST_TIMEOUT = "RequestTimeout";

    /**
     * Invalid signature.
     */
    static final String SIGNATURE_DOES_NOT_MATCH = "SignatureDoesNotMatch";

    /**
     * Source buckets is not configured with CORS.
     */
    static final String NO_SUCH_CORS_CONFIGURATION = "NoSuchCORSConfiguration";

    /**
     * The source bucket is not configured with static website (the index page
     * is null).
     */
    static final String NO_SUCH_WEBSITE_CONFIGURATION = "NoSuchWebsiteConfiguration";

    /**
     * The source bucket is not configured with lifecycle rule.
     */
    static final String NO_SUCH_LIFECYCLE = "NoSuchLifecycle";

    /**
     * Malformed xml.
     */
    static final String MALFORMED_XML = "MalformedXML";

    /**
     * Invalid encryption algorithm error.
     */
    static final String INVALID_ENCRYPTION_ALGORITHM_ERROR = "InvalidEncryptionAlgorithmError";

    /**
     * Invalid MD5 digest.
     */
    static final String INVALID_DIGEST = "InvalidDigest";

    /**
     * Invalid range of the character.
     */
    static final String INVALID_RANGE = "InvalidRange";

    /**
     * Security token is not supported.
     */
    static final String SECURITY_TOKEN_NOT_SUPPORTED = "SecurityTokenNotSupported";

    /**
     * Invalid response.
     */
    static final String INVALID_RESPONSE = "InvalidResponse";
}
