package com.digiwin.dap.middleware.emc.common.comm;


import org.apache.hc.core5.http.*;
import org.apache.hc.core5.http.protocol.HttpContext;

import java.io.IOException;

public class CustomHttpResponseInterceptor implements HttpResponseInterceptor {

    public static final CustomHttpResponseInterceptor INSTANCE = new CustomHttpResponseInterceptor();

    @Override
    public void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        int status = httpResponse.getCode();
        if (status == HttpStatus.SC_BAD_GATEWAY || status == HttpStatus.SC_SERVICE_UNAVAILABLE) {
            // 符合重试的状态码，抛出IOException进行重试
            throw new CustomStatusRetryException(httpResponse);
        }
    }
}
