package com.digiwin.dap.middleware.emc.common.comm;

import com.digiwin.dap.middleware.emc.ClientException;
import com.digiwin.dap.middleware.emc.HttpMethod;
import com.digiwin.dap.middleware.emc.common.utils.HttpHeaders;
import org.apache.hc.client5.http.classic.methods.*;


import java.net.URI;
import java.util.Map.Entry;

class HttpRequestFactory {

    public HttpUriRequestBase createHttpRequest(RequestMessage request) {
        URI uri = request.getEndpoint();

        HttpUriRequestBase httpRequest;
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            postMethod.setEntity(request.getHttpEntity());

            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            putMethod.setEntity(request.getHttpEntity());
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            if (request.getHttpEntity() != null) {
                HttpDeleteWithBody deleteMethod = new HttpDeleteWithBody(uri);
                deleteMethod.setEntity(request.getHttpEntity());
                httpRequest = deleteMethod;
            } else {
                httpRequest = new HttpDelete(uri);
            }
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }

        configureRequestHeaders(request, httpRequest);

        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpUriRequestBase httpRequest) {
        for (Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(HttpHeaders.CONTENT_LENGTH)
                    || entry.getKey().equalsIgnoreCase(HttpHeaders.HOST)) {
                continue;
            }
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }
}
