package com.digiwin.dap.middleware.emc.common.parser;

import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.emc.internal.model.StdError;
import com.digiwin.dap.middleware.util.JsonUtils;

/**
 * Used to convert an result stream to a java object.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class ErrorResponseParser implements ResponseParser<StdError> {

    @Override
    public StdError parse(ResponseMessage response) throws ResponseParseException {
        return JsonUtils.readValue(response.getError(), StdError.class);
    }
}
