package com.digiwin.dap.middleware.emc.common.parser;

import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;

/**
 * Used to convert an result stream to a java object.
 *
 * @author fobgochod
 * @since 1.0.0
 */
public interface ResponseParser<T> {

    /**
     * Converts the result from stream to a java object.
     *
     * @param response The http response message.
     * @return The java Type T object that the result stands for.
     * @throws ResponseParseException Failed to parse the result.
     */
    T parse(ResponseMessage response) throws ResponseParseException;
}
