package com.digiwin.dap.middleware.emc.internal;

/**
 * Defines a builder that adds a config to the EMCConfig entity.
 *
 * @author fobgochod
 * @since 5.2.0.0
 */
public final class EMCConfigBuilder {

    private String uri;
    private String appToken;

    /**
     * Enforce the use of factory methods.
     */
    private EMCConfigBuilder() {
    }

    public static EMCConfigBuilder create() {
        return new EMCConfigBuilder();
    }

    public static EMCConfigBuilder create(String uri, String appToken) {
        return new EMCConfigBuilder().uri(uri).appToken(appToken);
    }

    public EMCConfigBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public EMCConfigBuilder appToken(String appToken) {
        this.appToken = appToken;
        return this;
    }


    public EMCConfig build() {
        EMCConfig config = new EMCConfig();
        config.setUri(uri);
        config.setAppToken(appToken);
        return config;
    }
}
