package com.digiwin.dap.middleware.emc.internal.operation;

import com.digiwin.dap.middleware.emc.HttpMethod;
import com.digiwin.dap.middleware.emc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.emc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.emc.internal.EMCOperation;
import com.digiwin.dap.middleware.emc.internal.EMCRequestMessageBuilder;
import com.digiwin.dap.middleware.emc.internal.ResponseParsers;
import com.digiwin.dap.middleware.emc.model.MessageInfoRequest;

/**
 * 发送消息
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class EMCBaseOperation extends EMCOperation {

    public EMCBaseOperation(ServiceClient client) {
        super(client);
    }

    public void send(MessageInfoRequest original) {
        RequestMessage request = EMCRequestMessageBuilder.create()
                .setEndpoint(config.getSendUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}