package com.digiwin.dap.middleware.emc.model;

import com.digiwin.dap.middleware.emc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

/**
 * 发送信息
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class MessageInfoRequest extends GenericRequest {

    private MessageInfo messageInfo;

    public MessageInfo getMessageInfo() {
        return messageInfo;
    }

    public void setMessageInfo(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(messageInfo))
                .setContentType(ContentType.APPLICATION_JSON)
                .build();
    }
}
