/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc;

import com.digiwin.dap.middleware.emc.ClientConfiguration;
import com.digiwin.dap.middleware.emc.EMC;
import com.digiwin.dap.middleware.emc.common.comm.DefaultServiceClient;
import com.digiwin.dap.middleware.emc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.emc.internal.EMCConfig;
import com.digiwin.dap.middleware.emc.internal.operation.EMCBaseOperation;
import com.digiwin.dap.middleware.emc.model.MessageInfo;
import com.digiwin.dap.middleware.emc.model.MessageInfoRequest;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMCClient
implements EMC {
    private static final Logger logger = LoggerFactory.getLogger(EMCClient.class);
    private final EMCBaseOperation baseOperation;
    protected ServiceClient serviceClient;

    EMCClient(EMCConfig config) {
        this(config, null);
    }

    EMCClient(EMCConfig config, ClientConfiguration clientConfig) {
        this.serviceClient = clientConfig == null ? new DefaultServiceClient(config) : new DefaultServiceClient(config, clientConfig);
        this.baseOperation = new EMCBaseOperation(this.serviceClient);
    }

    @Override
    public void send(String eventId, Object payload, String userToken) {
        this.send(eventId, payload, null, userToken);
    }

    @Override
    public void send(String eventId, Object payload, String contacts, String userToken) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setEventId(eventId);
        messageInfo.setContacts(contacts);
        messageInfo.setMessage(Collections.singletonMap("data", payload));
        this.send(messageInfo, userToken);
    }

    @Override
    public void send(MessageInfo message, String userToken) {
        MessageInfoRequest request = new MessageInfoRequest();
        request.setMessageInfo(message);
        request.addHeader("digi-middleware-auth-user", userToken);
        this.baseOperation.send(request);
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            logger.error("shutdown throw exception: ", (Throwable)e);
        }
    }

    @Override
    public String getConnectionPoolStats() {
        try {
            return this.serviceClient.getConnectionPoolStats();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

