/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.common.utils;

import com.digiwin.dap.middleware.emc.ClientException;
import com.digiwin.dap.middleware.emc.EMCException;
import com.digiwin.dap.middleware.emc.internal.EMCUtils;
import com.digiwin.dap.middleware.emc.internal.model.StdError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.NonReadableChannelException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.NoHttpResponseException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonReadableChannelException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static EMCException createInvalidResponseException(String requestId, String rawResponseError, Throwable cause) {
        return ExceptionFactory.createInvalidResponseException(requestId, EMCUtils.EMC_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()), rawResponseError);
    }

    public static EMCException createInvalidResponseException(String requestId, String message, String rawResponseError) {
        return ExceptionFactory.createEMCException(requestId, "InvalidResponse", message, rawResponseError);
    }

    public static EMCException createEMCException(String requestId, String errorCode, String message, String rawResponseError) {
        return new EMCException(message, errorCode, requestId, null, null, null, null, rawResponseError);
    }

    public static EMCException createEMCException(String requestId, String errorCode, String message) {
        return new EMCException(message, errorCode, requestId, null, null, null, null);
    }

    public static EMCException createUnknownEMCException(String requestId, int statusCode) {
        String message = "No body in response, http status code " + statusCode;
        return new EMCException(message, "Unknown", requestId, null, null, null, null);
    }

    public static EMCException createEMCException(StdError errorResult) {
        return new EMCException(String.format("%s\uff1a%s", errorResult.getErrorMessage(), errorResult.getMessage()), errorResult.getErrorCode());
    }
}

