/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.internal;

import com.digiwin.dap.middleware.emc.ClientException;
import com.digiwin.dap.middleware.emc.EMCException;
import com.digiwin.dap.middleware.emc.ServiceException;
import com.digiwin.dap.middleware.emc.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.emc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.emc.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.emc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.emc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.emc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.emc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.emc.internal.EMCConfig;
import com.digiwin.dap.middleware.emc.internal.EMCUtils;
import com.digiwin.dap.middleware.emc.internal.ErrorResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EMCOperation {
    protected static final Logger logger = LoggerFactory.getLogger(EMCOperation.class);
    protected static ResponseHandler errorResponseHandler = new ErrorResponseHandler();
    protected ServiceClient client;
    protected EMCConfig config;

    protected EMCOperation(ServiceClient client) {
        this.client = client;
        this.config = client.getConfig();
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser) {
        return this.doOperation(request, parser, true);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, boolean keepResponseOpen) {
        ExecutionContext context = this.createDefaultContext();
        ResponseMessage response = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(response);
        }
        catch (ResponseParseException rpe) {
            EMCException de = ExceptionFactory.createInvalidResponseException(response.getRequestId(), rpe.getMessage(), rpe);
            logger.error("Unable to parse response error: ", (Throwable)rpe);
            throw de;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws ServiceException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                EMCUtils.safeCloseResponse(response);
            }
        }
    }

    protected ExecutionContext createDefaultContext() {
        ExecutionContext context = new ExecutionContext();
        context.addResponseHandler(errorResponseHandler);
        return context;
    }
}

