/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.internal;

import com.digiwin.dap.middleware.emc.HttpMethod;
import com.digiwin.dap.middleware.emc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.emc.internal.model.WebServiceRequest;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.HttpEntity;

public class EMCRequestMessageBuilder {
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpEntity entity;
    private boolean forceRetry;
    private WebServiceRequest originalRequest;

    public static EMCRequestMessageBuilder create() {
        return new EMCRequestMessageBuilder();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public EMCRequestMessageBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public EMCRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public EMCRequestMessageBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public EMCRequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public EMCRequestMessageBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public EMCRequestMessageBuilder setForceRetry(boolean forceRetry) {
        this.forceRetry = forceRetry;
        return this;
    }

    public EMCRequestMessageBuilder setOriginalRequest(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public RequestMessage build() {
        RequestMessage request = new RequestMessage(this.originalRequest);
        request.setEndpoint(this.endpoint);
        request.setMethod(this.method);
        request.setHeaders(this.headers);
        request.setHttpEntity(this.entity);
        request.setForceRetry(this.forceRetry);
        return request;
    }
}

