/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.internal;

import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.emc.common.utils.ResourceManager;
import java.io.IOException;

public class EMCUtils {
    public static final ResourceManager EMC_RESOURCE_MANAGER = ResourceManager.getInstance("i18n/emc");
    private static final String ENDPOINT_REGEX = "^[a-zA-Z0-9._-]+$";

    public static boolean validateEndpoint(String endpoint) {
        if (endpoint == null) {
            return false;
        }
        return endpoint.matches(ENDPOINT_REGEX);
    }

    public static void ensureEndpointValid(String endpoint) {
        if (!EMCUtils.validateEndpoint(endpoint)) {
            throw new IllegalArgumentException(EMC_RESOURCE_MANAGER.getFormattedString("EndpointInvalid", endpoint));
        }
    }

    public static void safeCloseResponse(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

