/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.internal;

import com.digiwin.dap.middleware.emc.ClientException;
import com.digiwin.dap.middleware.emc.EMCException;
import com.digiwin.dap.middleware.emc.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.emc.common.parser.ErrorResponseParser;
import com.digiwin.dap.middleware.emc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.emc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.emc.internal.EMCUtils;
import com.digiwin.dap.middleware.emc.internal.model.StdError;

public class ErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws EMCException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createEMCException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createEMCException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createEMCException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            if (statusCode == 403) {
                throw ExceptionFactory.createEMCException(requestId, "AccessForbidden", "AccessForbidden");
            }
            throw ExceptionFactory.createUnknownEMCException(requestId, statusCode);
        }
        try {
            try {
                ErrorResponseParser parser = new ErrorResponseParser();
                StdError stdError = parser.parse(response);
                throw ExceptionFactory.createEMCException(stdError);
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, response.getError(), e);
            }
        }
        catch (Throwable throwable) {
            EMCUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

