/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.emc.internal;

import com.digiwin.dap.middleware.emc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.emc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.emc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.emc.internal.EMCUtils;
import com.digiwin.dap.middleware.emc.internal.model.StdData;
import com.digiwin.dap.middleware.emc.model.MessageResult;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

public final class ResponseParsers {
    public static final EmptyResponseParser emptyResponseParser = new EmptyResponseParser();
    public static final SendResponseParser sendResponseParser = new SendResponseParser();
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            EMCUtils.safeCloseResponse(response);
            return response;
        }
    }

    public static final class SendResponseParser
    implements ResponseParser<MessageResult> {
        @Override
        public MessageResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<MessageResult>>(this){});
                MessageResult messageResult = (MessageResult)stdData.getData();
                return messageResult;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                EMCUtils.safeCloseResponse(response);
            }
        }
    }
}

