/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.accessory.AccessoryGoodsSaveVO;
import com.digiwin.dap.middleware.gmc.domain.accessory.AccessoryGoodsVO;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.service.accessory.AccessoryService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/accessory"})
public class AccessoryGoodsController {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;

    @PostMapping(value={"/save"})
    public StdData<?> save(@RequestBody AccessoryGoodsSaveVO input) {
        this.accessoryService.save(input);
        return StdData.ok().build();
    }

    @PostMapping(value={"list"})
    public StdData<?> findList(@RequestBody AccessoryGoodsVO input) {
        List result = this.accessoryService.findList(input);
        return StdData.ok((Object)result);
    }

    @Deprecated
    @PostMapping(value={"/platform/check"})
    public StdData<?> check(@RequestBody AccessoryGoodsSaveVO input) {
        if (input.getType() != null && input.getType() == 0) {
            return StdData.ok().build();
        }
        SellingStrategy strategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(input.getStrategySid().longValue());
        List platformCodes = this.goodsOnPlatformMapper.getPlatformCodeByGoodsCodeNoDefaultStrategy(strategy.getGoodsCode());
        input.getAccessories().stream().map(AccessoryGoodsVO::getAccessoryCode).forEach(platformCodes::remove);
        if (platformCodes.isEmpty()) {
            return StdData.ok().build();
        }
        return StdData.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)(String.join((CharSequence)",", platformCodes) + "\uff0c\u672a\u8bbe\u7f6e\u76f8\u4f9d\u65b9\u6848\uff0c\u4e0d\u4f1a\u968f\u4e3b\u5546\u54c1\u5f00\u901a"));
    }
}

