/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.authoritysummary.AuthoritySummaryCondition;
import com.digiwin.dap.middleware.gmc.domain.request.SaveAuthoritySummaryRequest;
import com.digiwin.dap.middleware.gmc.domain.request.SearchMainGoodsRequest;
import com.digiwin.dap.middleware.gmc.service.authoritysummary.AuthoritySummaryService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/authority/summary"})
public class AuthoritySummaryController {
    @Autowired
    private AuthoritySummaryService authoritySummaryService;

    @GetMapping(value={"/check"})
    public StdData<?> checkInChildGoods(@RequestParam(value="goodsCode") String goodsCode) {
        this.authoritySummaryService.checkChildGoods(goodsCode);
        return StdData.ok().build();
    }

    @PostMapping(value={"/save"})
    public StdData<?> saveAuthoritySummary(@RequestBody SaveAuthoritySummaryRequest request) {
        request.valid();
        this.authoritySummaryService.checkChildGoods(request.getGoodsCode());
        this.authoritySummaryService.saveAuthoritySummary(request.getGoodsCode(), request.getChildGoodsCodeList());
        return StdData.ok().build();
    }

    @GetMapping(value={"/list/child"})
    public StdData<?> listChildGoods(@RequestParam(value="goodsCode") String goodsCode) {
        List childGoodList = this.authoritySummaryService.getChildGoodsInfo(goodsCode);
        return StdData.ok((Object)childGoodList);
    }

    @GetMapping(value={"/search/main"})
    public StdData<?> searchMainGoods(Page page, SearchMainGoodsRequest request) {
        AuthoritySummaryCondition authoritySummaryCondition = request.toAuthoritySummaryCondition();
        PageSerializable mainGoodsList = this.authoritySummaryService.searchMainGoodsByCondition(page, authoritySummaryCondition);
        return StdData.ok((Object)mainGoodsList);
    }
}

