/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationSearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.AuthorizationVO;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.repository.AuthorizationDataRepository;
import com.digiwin.dap.middleware.gmc.repository.AuthorizationRepository;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationCrudService;
import com.digiwin.dap.middleware.gmc.service.authorization.AuthorizationService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/authorization"})
public class AuthorizationController {
    @Autowired
    private AuthorizationRepository authorizationRepository;
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private AuthorizationDataRepository authorizationDataRepository;
    @Autowired
    private AuthorizationCrudService authorizationCrudService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsMapper goodsMapper;

    @GetMapping(value={"/list"})
    public ResponseEntity<?> getAuthorizationList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="a.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        AuthorizationSearchParamVO authorizationSearchParamVO = this.getAuthorizationSearchParamVO(params);
        PageSerializable authorizationList = this.authorizationService.getAuthorizationList(authorizationSearchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)StdData.ok((Object)authorizationList));
    }

    @GetMapping(value={"/tenant/{tenantId:.+}"})
    public ResponseEntity<?> getAuthorizations(@PathVariable String tenantId, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="a.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        AuthorizationSearchParamVO authorizationSearchParamVO = this.getAuthorizationSearchParamVO(params);
        authorizationSearchParamVO.setTenantId(tenantId);
        PageSerializable authorizationList = this.authorizationService.getAuthorizationList(authorizationSearchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)StdData.ok((Object)authorizationList));
    }

    @GetMapping(value={"/{authorizationSid}"})
    public ResponseEntity<?> getAuthorizationInfo(@PathVariable long authorizationSid) {
        AuthorizationVO authorizationVO = this.authorizationService.getAuthorizationInfo(authorizationSid);
        return ResponseEntity.ok((Object)StdData.ok((Object)authorizationVO));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> saveAuthorization(@Validated @RequestBody AuthorizationVO authorizationVO) {
        if (authorizationVO.getAuthorizationGoods().size() == 0) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u7ecf\u9500\u5546\u6388\u6743\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List goodsSids = authorizationVO.getAuthorizationGoods().stream().map(AuthorizationGoodsVO::getGoodsSid).collect(Collectors.toList());
        int counts = this.goodsMapper.countDeviceGoods(goodsSids);
        if (counts > 1) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5546\u54c1\u7ec4\u4ec5\u80fd\u5b58\u5728\u4e00\u7b14\u989d\u5916\u8bbe\u5907\u8d44\u6e90\u7c7b\u5546\u54c1");
        }
        if (authorizationVO.getSid() == null || authorizationVO.getSid() == 0L) {
            if (this.authorizationRepository.existsById(authorizationVO.getId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u7ecf\u9500\u5546\u5408\u540c\u5355\u53f7\u5df2\u5b58\u5728");
            }
            long sid = this.authorizationService.create(authorizationVO);
            return ResponseEntity.ok((Object)StdData.ok((Object)sid));
        }
        if (this.authorizationDataRepository.existsByAuthorizationSid(authorizationVO.getSid().longValue())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5df2\u7ecf\u5b58\u5728\u6388\u6743\u6570\u636e\uff0c\u4e0d\u80fd\u7f16\u8f91");
        }
        this.authorizationService.update(authorizationVO);
        return ResponseEntity.ok((Object)StdData.ok((Object)authorizationVO.getSid()));
    }

    @GetMapping(value={"/exists/{authorizationId}"})
    public ResponseEntity<?> existsAuthorizationCode(@PathVariable String authorizationId) {
        if (this.authorizationRepository.existsById(authorizationId).booleanValue()) {
            return ResponseEntity.ok((Object)StdData.ok((Object)true));
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)false));
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{authorizationSid}"})
    public ResponseEntity<?> deleteAuthorization(@PathVariable long authorizationSid) {
        if (!this.authorizationCrudService.exists(authorizationSid)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u7ecf\u9500\u5546\u6388\u6743\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (this.authorizationDataRepository.existsByAuthorizationSid(authorizationSid)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5df2\u7ecf\u5b58\u5728\u6388\u6743\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.authorizationService.remove(authorizationSid);
        return ResponseEntity.ok((Object)StdData.ok((Object)HttpStatus.OK));
    }

    @GetMapping(value={"/goods"})
    public ResponseEntity<?> getAuthorizationGoodsList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="g.create_date desc") String orderBy, @RequestParam(name="goodsContent", required=false) String goodsContent) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.goodsService.getAuthorizationGoodsList(pageNum.intValue(), pageSize.intValue(), orderBy, goodsContent)));
    }

    @GetMapping(value={"/goods/{code}"})
    public ResponseEntity<?> getAuthorizationGoodsDealerSellingStrategy(@PathVariable String code) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.goodsService.getAuthorizationGoodsDealerSellingStrategy(code)));
    }

    @GetMapping(value={"/{sid}/remainingcount"})
    public ResponseEntity<?> getAuthorizationRemainingCount(@PathVariable long sid) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.authorizationService.getAuthorizationRemainingCount(sid)));
    }

    private AuthorizationSearchParamVO getAuthorizationSearchParamVO(@RequestParam(name="params", required=false) String params) {
        AuthorizationSearchParamVO authorizationSearchParamVO;
        try {
            authorizationSearchParamVO = StringUtils.isEmpty((Object)params) ? new AuthorizationSearchParamVO() : (AuthorizationSearchParamVO)JsonUtils.createObjectMapper().readValue(params, AuthorizationSearchParamVO.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u5f02\u5e38");
        }
        return authorizationSearchParamVO;
    }
}

