/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.GenerateAuthorizationDataVO;
import com.digiwin.dap.middleware.gmc.domain.dealerauthorization.SearchAuthorizationDataVO;
import com.digiwin.dap.middleware.gmc.service.authorizationdata.AuthorizationDataQueryService;
import com.digiwin.dap.middleware.gmc.service.authorizationdata.AuthorizationDataService;
import com.github.pagehelper.PageSerializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/authorizationdata"})
public class AuthorizationDataController {
    @Autowired
    private AuthorizationDataService authorizationDataService;
    @Autowired
    private AuthorizationDataQueryService authorizationDataQueryService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/generate"})
    public StdData<?> generateAuthorizationData(@Validated @RequestBody GenerateAuthorizationDataVO generateAuthorizationDataVO) {
        this.authorizationDataService.generateAuthorizationData(generateAuthorizationDataVO);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/abolish/{sid}"})
    public StdData<?> abolishAuthorizationData(@PathVariable(value="sid") long sid) {
        this.authorizationDataService.abolishAuthorizationData(sid);
        return StdData.ok().build();
    }

    @GetMapping(value={"/authSid/{authSid}"})
    public ResponseEntity<?> getGoodsCounsel(@PathVariable(value="authSid") long authSid, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ad.begin_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchAuthorizationDataVO searchAuthorizationDataVO = SearchAuthorizationDataVO.getSelf((String)params);
        searchAuthorizationDataVO.setAuthSid(authSid);
        PageSerializable authorizationDataList = this.authorizationDataQueryService.getAuthorizationDataPage(searchAuthorizationDataVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)StdData.ok((Object)authorizationDataList));
    }
}

