/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.gmc.domain.calculate.PackGoodVO;
import com.digiwin.dap.middleware.gmc.service.goods.CalculateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CalculateController {
    @Autowired
    private CalculateService calculateService;

    @PostMapping(value={"/api/gmc/v2/goods/calculate/price/pack"})
    public ResponseEntity<?> calculatePriceForPack(@RequestBody PackGoodVO packGoodVO) {
        AssertUtils.paramHasText((String)packGoodVO.getTenantId(), (String)"tenantId");
        AssertUtils.paramNotNull((Object)packGoodVO.getPackSid(), (String)"packSid");
        AssertUtils.paramNotNull((Object)packGoodVO.getOrderNumber(), (String)"orderNumber");
        Assert.notEmpty((Collection)packGoodVO.getGoods(), (String)"Goods:\u7ec4\u5408\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        return new ResponseEntity((Object)this.calculateService.calculatePackPrice(packGoodVO), HttpStatus.OK);
    }
}

