/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class CategoryController {
    @Autowired
    CategoryRepository categoryRepository;

    @RequestMapping(value={"/goodscategory"}, method={RequestMethod.GET})
    public ResponseEntity<?> getGoodsCategoryList() {
        List categories = this.categoryRepository.findAll();
        return ResponseEntity.ok((Object)categories);
    }

    @RequestMapping(value={"/goodscategory/add"}, method={RequestMethod.POST})
    public ResponseEntity<?> addGoodsCategory(@RequestBody Category category) {
        this.categoryRepository.save((Object)category);
        return ResponseEntity.ok((Object)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/goodscategory/update"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateGoodsCategory(@RequestBody Category category) {
        Category category1 = this.categoryRepository.findByCode(category.getCode());
        category1.setCode(category.getCode());
        category1.setName(category.getName());
        this.categoryRepository.save((Object)category1);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RequestMapping(value={"/goodscategory/delete"}, method={RequestMethod.POST})
    public ResponseEntity<?> deleteGoodsCategory(@RequestBody Category category) {
        Category category1 = this.categoryRepository.findByCode(category.getCode());
        if (category1 != null) {
            this.categoryRepository.delete((Object)category1);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

