/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.CommonParamTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.commonparam.CommonParamDTO;
import com.digiwin.dap.middleware.gmc.entity.CommonParam;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsCategory;
import com.digiwin.dap.middleware.gmc.repository.CommonParamRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsCategoryRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.service.commonparam.CommonParamCrudService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudgoods"})
public class CommonParamController {
    @Autowired
    private CommonParamCrudService commonParamCrudService;
    @Autowired
    private CommonParamRepository commonParamRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private GoodsCategoryRepository goodsCategoryRepository;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/commonparam/add"})
    public StdData<?> save(@RequestBody CommonParam commonParam) {
        Assert.hasText((String)commonParam.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        CommonParam paramExist = this.commonParamRepository.findByIdAndType(commonParam.getId(), commonParam.getType());
        if (null != paramExist) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("id[%s]\u5df2\u5b58\u5728", commonParam.getId()));
        }
        return StdData.ok((Object)this.commonParamCrudService.create((BaseEntity)commonParam));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/commonparam/mod"})
    public StdData<?> update(@RequestBody CommonParamDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"sid\u4e0d\u80fd\u4e3a\u7a7a");
        CommonParam commonParam = (CommonParam)this.commonParamRepository.findById((Object)dto.getSid()).orElseThrow(() -> new BusinessException(String.format("\u516c\u5171\u53c2\u6570[%s]\u4e0d\u5b58\u5728", dto.getSid())));
        BeanUtils.copyProperties((Object)dto, (Object)commonParam);
        this.commonParamCrudService.update((BaseEntity)commonParam);
        return StdData.ok((Object)commonParam);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/commonparam/del"})
    public StdData<?> delete(@RequestBody CommonParamDTO dto) {
        List goodsCategoryList;
        List goods;
        String goodsCodes;
        Assert.notNull((Object)dto.getSid(), (String)"sid\u4e0d\u80fd\u4e3a\u7a7a");
        CommonParam commonParam = (CommonParam)this.commonParamRepository.findById((Object)dto.getSid()).orElseThrow(() -> new BusinessException(String.format("\u516c\u5171\u53c2\u6570[%s]\u4e0d\u5b58\u5728", dto.getSid())));
        if (CommonParamTypeEnum.GOODS.getValue().equals(commonParam.getType()) && !StringUtils.isEmpty((Object)(goodsCodes = (goods = this.goodsRepository.findByProductCode(commonParam.getId())).stream().map(Goods::getCode).collect(Collectors.joining(","))))) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_PRODUCT_DELETE, new Object[]{goodsCodes});
        }
        if (CommonParamTypeEnum.GOODS_CATEGORY.getValue().equals(commonParam.getType()) && !StringUtils.isEmpty((Object)(goodsCodes = (goodsCategoryList = this.goodsCategoryRepository.findByCategoryId(commonParam.getId())).stream().map(GoodsCategory::getGoodsCode).collect(Collectors.joining(","))))) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_PRODUCT_DELETE, new Object[]{goodsCodes});
        }
        this.commonParamCrudService.deleteById(dto.getSid().longValue());
        return StdData.ok((Object)Boolean.TRUE);
    }

    @PostMapping(value={"/commonparam/exist"})
    public StdData<?> exist(@RequestBody CommonParamDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)Optional.ofNullable(this.commonParamRepository.findByIdAndType(dto.getId(), dto.getType())).isPresent());
    }

    @PostMapping(value={"/commonparams"})
    public StdData<?> getCommonParams(@RequestBody CommonParamDTO dto) {
        return StdData.ok((Object)this.commonParamCrudService.findCommonParams(dto));
    }
}

