/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.MyCouponVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.ReceiveCouponVO;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponQueryService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponQueryService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponService;
import com.digiwin.dap.middleware.gmc.service.coupon.ReceiveCouponService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/coupon"})
public class CouponController {
    @Autowired
    IamService iamService;
    @Autowired
    CouponQueryService couponQueryService;
    @Autowired
    MyCouponQueryService myCouponQueryService;
    @Autowired
    ReceiveCouponService receiveCouponService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private MyCouponService myCouponService;

    @RequestMapping(value={"/unclaimed"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCoupons(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        List couponInfoVos = user == null ? this.couponService.queryCoupons(0L, 0L) : this.couponService.queryCoupons(user.getTenantSid(), user.getSid());
        return ResponseEntity.ok((Object)couponInfoVos);
    }

    @RequestMapping(value={"/goodscategory/{goodsCategory}/goods/{goodsCode}/byowner"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCouponsByUserAndProduct(@PathVariable String goodsCategory, @PathVariable String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) throws Exception {
        List couponInfoVOs = this.myCouponService.queryCouponsByUserAndProduct(user.getTenantSid(), user.getSid(), goodsCategory, goodsCode);
        return ResponseEntity.ok((Object)couponInfoVOs);
    }

    @RequestMapping(value={"/{couponsid}/enable"}, method={RequestMethod.GET})
    public ResponseEntity<?> isEnable(@PathVariable String couponsid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Boolean result = this.myCouponService.isEnable(couponsid, user.getTenantSid(), user.getSid());
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(1);
        resultMap.put("canUse", result);
        return ResponseEntity.ok(resultMap);
    }

    @GetMapping(value={"/goodscategory/{categoryId}/goods/{goodsCode}"})
    public ResponseEntity<?> getGoodsCanUseCoupon(@PathVariable(value="categoryId") String categoryId, @PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        List goodsCanUseCouponVOS = authoredUser == null ? this.couponQueryService.getGoodsCanUseCoupon(0L, 0L, categoryId, goodsCode) : this.couponQueryService.getGoodsCanUseCoupon(authoredUser.getTenantSid(), authoredUser.getSid(), categoryId, goodsCode);
        return ResponseEntity.ok((Object)goodsCanUseCouponVOS);
    }

    @GetMapping(value={"/mycoupon"})
    public ResponseEntity<?> getMyCoupon(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        MyCouponVO myCouponVO = this.myCouponQueryService.getMyCouponVo(authoredUser.getTenantSid(), authoredUser.getSid());
        return ResponseEntity.ok((Object)myCouponVO);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> receiveCoupon(@RequestBody ReceiveCouponVO receiveCouponVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u8bf7\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599\u6216\u52a0\u5165\u4f01\u4e1a\uff0c\u5177\u6709\u8d2d\u4e70\u8d44\u683c\uff0c\u518d\u9886\u53d6\u4f18\u60e0\u5238");
        }
        Map resultMap = this.receiveCouponService.receiveCoupon(authoredUser.getTenantSid(), authoredUser.getSid(), receiveCouponVO.getCouponRuleSid().longValue());
        return ResponseEntity.ok((Object)resultMap);
    }
}

