/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponCategory;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponExclusiveVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponInfoVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponRuleType;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponRuleVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponSearchParamVO;
import com.digiwin.dap.middleware.gmc.entity.coupon.CouponType;
import com.digiwin.dap.middleware.gmc.mapper.CouponRuleMapper;
import com.digiwin.dap.middleware.gmc.repository.CouponRuleRepository;
import com.digiwin.dap.middleware.gmc.repository.CouponTypeRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveCrudService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponExclusiveService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleService;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponTypeService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/couponmanage"})
public class CouponManageController {
    @Autowired
    private CouponTypeService couponTypeService;
    @Autowired
    private CouponTypeRepository couponTypeRepository;
    @Autowired
    private CouponRuleService couponRuleService;
    @Autowired
    private CouponExclusiveService couponExclusiveService;
    @Autowired
    private CouponRuleRepository couponRuleRepository;
    @Autowired
    private CouponRuleMapper couponRuleMapper;
    @Autowired
    private CouponExclusiveCrudService couponExclusiveCrudService;

    @GetMapping(value={"/coupontype/list"})
    public ResponseEntity<?> getCouponTypeList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        CouponSearchParamVO couponSearchParamVO = this.getCouponSearchParamVO(params);
        PageSerializable couponTypeList = this.couponTypeService.getCouponTypeList(couponSearchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)couponTypeList);
    }

    @GetMapping(value={"/coupontype/{couponCategory}"})
    public ResponseEntity<?> getCouponTypeByCategory(@PathVariable CouponCategory couponCategory) {
        List couponTypes = this.couponTypeRepository.getAllByStatusAndCategory(Boolean.valueOf(true), couponCategory);
        return ResponseEntity.ok((Object)couponTypes);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/coupontype"})
    public ResponseEntity<?> saveCouponType(@Validated @RequestBody CouponType couponType) {
        this.couponTypeService.save(couponType);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/coupontype/{couponTypeSid}/{status}"})
    public ResponseEntity<?> saveCouponType(@PathVariable long couponTypeSid, @PathVariable Boolean status) {
        this.couponTypeService.updateCouponTypeStatus(couponTypeSid, status);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/couponrule/list"})
    public ResponseEntity<?> getCouponRuleList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="c.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        CouponSearchParamVO couponSearchParamVO = this.getCouponSearchParamVO(params);
        PageSerializable couponRuleList = this.couponRuleService.getCouponRuleList(couponSearchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)couponRuleList);
    }

    @GetMapping(value={"/couponrule/{couponRuleSid}"})
    public ResponseEntity<?> getCouponRuleInfo(@PathVariable long couponRuleSid) {
        CouponRuleVO couponRuleVO = this.couponRuleService.getCouponRuleInfo(couponRuleSid);
        return ResponseEntity.ok((Object)couponRuleVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/couponrule"})
    public ResponseEntity<?> saveCouponRule(@Validated @RequestBody CouponRuleVO couponRuleVO) {
        if (StringUtils.isEmpty((Object)couponRuleVO.getSid()) || couponRuleVO.getSid() == 0L) {
            if (CouponRuleType.REFERRALCODE.equals((Object)couponRuleVO.getCouponRuleType())) {
                Assert.isTrue((couponRuleVO.getSuitableGoods().size() == 1 ? 1 : 0) != 0, (String)"\u5238\u89c4\u5219\u7c7b\u578b\u4e3a\u63a8\u8350\u7801\u7c7b\u578b\u65f6\u9002\u7528\u5546\u54c1\u53ea\u80fd\u5355\u9009");
            }
            if (this.couponRuleRepository.existsByCode(couponRuleVO.getCode()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u5238\u89c4\u5219id\u5df2\u5b58\u5728");
            }
            this.couponRuleService.create(couponRuleVO);
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        this.couponRuleService.update(couponRuleVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/couponrule/exclusivecoupon"})
    public StdData<?> generateExclusiveCoupon(@Validated @RequestBody CouponExclusiveVO couponExclusiveVO) {
        if (couponExclusiveVO == null) {
            return StdData.ok().build();
        }
        ArrayList<CouponInfoVO> coupons = new ArrayList<CouponInfoVO>();
        for (int i = 0; i < couponExclusiveVO.getCount(); ++i) {
            CouponInfoVO couponInfoVO = new CouponInfoVO();
            couponInfoVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            couponInfoVO.setEffectiveDate(couponExclusiveVO.getEffectiveDate());
            couponInfoVO.setExpiredDate(couponExclusiveVO.getExpiredDate());
            coupons.add(couponInfoVO);
        }
        couponExclusiveVO.setCreateDate(LocalDateTime.now());
        couponExclusiveVO.setCoupons(coupons);
        return StdData.ok((Object)couponExclusiveVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/couponrule/exclusivecoupon/{exclusiveCouponSid}"})
    public StdData<?> deleteExclusiveCoupon(@PathVariable long exclusiveCouponSid) {
        this.couponExclusiveCrudService.deleteExclusiveCoupon(exclusiveCouponSid);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/couponrule/exclusivecoupon/{exclusiveCouponSid}/email"})
    public ResponseEntity<?> sendExclusiveCouponEmail(@PathVariable long exclusiveCouponSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Map emailMap = this.couponExclusiveService.sendExclusiveCouponEmail(exclusiveCouponSid, authoredUser);
        return ResponseEntity.ok((Object)StdData.ok((Object)emailMap));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/couponrule/{couponRuleSid}/status/{status}"})
    public ResponseEntity<?> saveCouponRule(@PathVariable long couponRuleSid, @PathVariable Boolean status) {
        this.couponRuleMapper.updateCouponRuleStatus(status.booleanValue(), couponRuleSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/couponrule/{sid}"})
    public ResponseEntity<?> deleteCouponRule(@PathVariable long sid) {
        this.couponRuleService.remove(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/coupontype/{sid}"})
    public ResponseEntity<?> deleteCouponType(@PathVariable long sid) {
        this.couponTypeService.remove(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private CouponSearchParamVO getCouponSearchParamVO(@RequestParam(name="params", required=false) String params) {
        CouponSearchParamVO couponSearchParamVO;
        try {
            couponSearchParamVO = StringUtils.isEmpty((Object)params) ? new CouponSearchParamVO() : (CouponSearchParamVO)JsonUtils.createObjectMapper().readValue(params, CouponSearchParamVO.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "params\u89e3\u6790\u5f02\u5e38");
        }
        return couponSearchParamVO;
    }
}

