/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.customform.CustomFormVO;
import com.digiwin.dap.middleware.gmc.repository.CustomFormRepository;
import com.digiwin.dap.middleware.gmc.service.customform.CustomFormGoodsService;
import com.digiwin.dap.middleware.gmc.service.customform.CustomFormService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gmc/v2/custom/form"})
public class CustomFormController {
    @Autowired
    private CustomFormService customFormService;
    @Autowired
    private CustomFormGoodsService customFormGoodsService;
    @Autowired
    private CustomFormRepository customFormRepository;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping
    public StdData save(@Validated @RequestBody CustomFormVO customFormVO) {
        return StdData.ok((Object)this.customFormService.save(customFormVO));
    }

    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/{sid}"})
    public StdData update(@PathVariable Long sid, @Validated @RequestBody CustomFormVO customFormVO) {
        customFormVO.setSid(sid);
        this.customFormService.update(customFormVO);
        return StdData.ok((Object)sid);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/goods"})
    public StdData saveGoods(@PathVariable Long sid, @RequestBody List<CustomFormGoodsVO> customFormGoodsVO) {
        return StdData.ok((Object)this.customFormGoodsService.update(sid, customFormGoodsVO));
    }

    @GetMapping(value={"/exists"})
    public StdData existsCustomForm(@RequestParam String name) {
        return StdData.ok((Object)this.customFormRepository.existsByName(name));
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{sid}"})
    public StdData delete(@PathVariable long sid) {
        return StdData.ok((Object)this.customFormService.delete(Long.valueOf(sid)));
    }

    @GetMapping(value={"/goods"})
    public StdData getCustomFormGoods() {
        return StdData.ok((Object)this.customFormGoodsService.getCustomFormGoodsList());
    }

    @GetMapping
    public StdData getCustomFormList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="c.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        CustomFormVO condition = CustomFormVO.getSelf((String)params);
        List customFormList = this.customFormService.getCustomFormList(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(customFormList));
    }

    @GetMapping(value={"/{sid}"})
    public StdData getCustomFormInfo(@PathVariable long sid) {
        return StdData.ok((Object)this.customFormService.getCustomForm(sid));
    }

    @GetMapping(value={"/goods/{goodsCode}"})
    public StdData getCustomFormInfoByGoodsCode(@PathVariable String goodsCode) {
        return StdData.ok((Object)this.customFormService.getCustomFormByGoodsCode(goodsCode));
    }
}

